c
c Second version of the program change_simfit_version
c ---------------------------------------------------
c
c This program reads a list of source DLLs and descriptions from the
c local file x64_change_simfit_version.config, then offers users the chance to 
c overwrite x64_maths.dll by a version of x64_maths.dll linked to the,
c appropriate library, e.g. w_numbers.dll for the Academic version,
c or the NAG library for NAG versions.
c
c The configuration file change_simfit_version.config
c ---------------------------------------------------
c The file x64_change_simfit_version.config must consist of one line
c each for the possible sources and descriptions as follows
c ...
c academic_maths.dll Academic version linked to x64_numbers.dll
c ...
c comments follow after the first % is encountered in position 1.
c
c
c author: w.g.bardsley, university of manchester, 07/06/2008
c
      program    main
      implicit   none
      integer    nitems
      integer    nmax
      parameter (nmax = 1024)
      character (len = 1024) :: lines(nmax)
      character (len = 1024) :: dlls(nmax)
      character (len = 60)   :: comments(nmax + 1)
      external   check_files, check_lines, swap_over
c
c does the file x64_change_simfit_version.cfg exist and contain any lines
c      
      call check_files (nitems, nmax,
     +                  lines) 
c
c if so, do the lines make sense as dll/comment pairs
c      
      call check_lines (nitems, nmax,
     +                  comments, dlls, lines)
c
c if so, should we overwrite w_maths.dll
c     
      call swap_over (nitems, nmax,
     +                comments, dlls)      
      end
c
c----------------------------------------------------------------------
c      
      subroutine check_files (nitems, nmax,
     +                        lines)
c
c attempt to locate and read the file change_simfit_version.config
c     
      implicit none
      integer,             intent (in)  :: nmax
      integer,             intent (out) :: nitems
      character (len = *), intent (out) :: lines(nmax)

      integer    i, ios
      integer    isend, nin
      parameter (isend = 4, nin = 10)
      character (len = 1024) :: strng1, strng2
      character (len = 32)  :: fname
      parameter (fname = 'x64_change_simfit_version.config')
      character (len = 80)  :: message1, message2
      parameter (message1 = 
     +'Cannot read data from the file x64_simfit_version.config',
     +           message2 =
     +'Cannot find the file x64_change_simfit_version.config')
      character (len = 1)   :: blank, pcent
      parameter (blank = ' ', pcent = '%')
      logical    there
      external   w_putall
      intrinsic  adjustl, len_trim
c
c initialise nitems and lines
c      
      nitems = 0
      do i = 1, nmax
         lines(i) = blank
      enddo  
c
c if change_simfit_version.cfg exists then open it and read lines
c       
      inquire (file = fname, exist = there) 
      if (there) then
         open (unit = nin, file = fname, iostat = ios)
         do while (ios.eq.0 .and. nitems.lt.nmax)
            read (nin,'(a)', iostat=ios) strng1
            if (ios.eq.0) then
               strng2 = adjustl(strng1)  
               if (len_trim(strng2).ge.1) then
                  if (strng2(1:1).ne.pcent) then
                     nitems = nitems + 1
                     lines(nitems) = strng2
                  else
                     ios = -1
                  endif      
               else
                  ios = -1
               endif  
            endif   
         enddo 
c
c inform user if data cannot be used
c         
         if (nitems.lt.1) call w_putall ( isend,
     +                                    message1)                
      else
c
c inform user if file not there
c      
        call w_putall (isend,
     +                 message2)        
      endif
      end                 
c
c-----------------------------------------------------------------------
c      
      subroutine check_lines (nitems, nmax,
     +                        comments, dlls, lines)
c
c attempt to analyse the file change_simfit_version.cfg
c     
      implicit none
      integer,             intent (in)    :: nmax
      integer,             intent (inout) :: nitems
      character (len = *), intent (inout) :: lines(nmax), dlls(nmax)
      character (len = *), intent (out)   :: comments(nmax + 1)
     +                                        

  
      integer    i, icount, l1, l2, l3
      integer    isend
      parameter (isend = 4)
      character (len = 1024) :: fname 
      character (len = 80)   :: message
      parameter (message =
     +'Cannot find any source dlls')
      character (len = 80)  :: no_data
      parameter (no_data =
     +'No description in x64_change_simfit_version.cfg')   
      character (len = 1)   :: blank
      parameter (blank = ' ')
      logical    there
      external   w_putall
      intrinsic  adjustl, index, len_trim  
c
c check that nitems >= 1
c
      if (nitems.lt.1) return
c
c initialise comments and dlls
c
      do i = 1, nmax
         comments(i) = blank
         dlls(i) = blank
      enddo 
      comments(nmax + 1) = blank   
c
c define comments and dlls
c      
      icount = 0
      do i = 1, nitems
         l3 = len_trim(lines(i))
         l1 = index(lines(i),blank)
         if (l1.gt.1) then
            fname = lines(i)(1:l1 - 1)
            inquire (file = fname, exist = there)
            if (there) then
               icount = icount + 1
               dlls(icount) = fname
               l2 = l1 + 1
               if (l3.gt.l2) then
                  comments(icount) = adjustl(lines(i)(l2:l3))
               else
                  comments(icount) = no_data(1:60)   
               endif   
            endif
         endif
      enddo
c
c inform user if sources cannot be found
c      
      nitems = icount 
      if (nitems.lt.1) call w_putall (isend,
     +                                message)         
      end
c
c-----------------------------------------------------------------------
c                     
      subroutine swap_over (nitems, nmax,
     +                      comments, dlls)
c
c attempt to act on the information retrieved from the file change_simfit_version.config
c     
      implicit none
      include <windows.ins>
c
c arguments
c      
      integer,                intent (in)    :: nmax
      integer,                intent (inout) :: nitems
      character (len = *), intent (in)    :: dlls(nmax) 
      character (len = *), intent (inout) :: comments(nmax + 1) 
c
c locals
c
c Note: when using /f_stdcall selected_int_kind prevents loading this subroutine
c      integer   (selected_int_kind(4)) ifail 
c      integer   (kind = 2) ifail
      integer    ifail*2 
      integer    i, isend, numdec
      integer    nhigh, nwide
      parameter (nhigh = 20, nwide = 50)
      integer    i_give_help
      double precision high
      parameter (high = 0.75d+00)
      character  source*1024, strng*1024, targit*13 
      character  blank*1, word13*13
      parameter (blank = ' ', word13 = 'x64_maths.dll')
      character  yes1*80, yes2*80, no*80
      parameter (yes1 =
     +'Success ... x64_maths.dll has been overwritten',
     +           yes2 =
     +'x64_maths.dll may have been overwritten using cissue@',
     +             no = 
     +'Failure ... could not overwrite x64_maths.dll') 
      logical    action, done, over, there, try_cissue     
      logical    use_cissue
      parameter (use_cissue = .false.)
      external   i_give_help, w_putall, more_info
c
c check that nitems >= 1
c
      if (nitems.lt.1) return
c
c action depends on whether targit exists 
c        
      targit = word13
      inquire (file = targit, exist = there)  
      if (there) then
         nitems = nitems + 1
         comments(nitems) = 'Cancel  ...  Accept the current version'  
         numdec = nitems
      else
         numdec = 1
      endif   
c
c list box for decision
c      
      i = winio@('%sy[3d_thin, no_sysmenu]&')
      i = winio@('%ca[Program: x64_change_simfit_version.exe]&')
      i = winio@(
     +'Before using this program to change the Simfit version note:&')
      i = winio@('%nl   &')
      i = winio@('%nl&')
      i = winio@(
     +'1. The Academic version does not need additional libraries.&')
      i = winio@('%nl   &')
      i = winio@('%nl&')
      i = winio@(
     +'2. The NAG library versions have extra functionality but only&')
      i = winio@('%nl&')
      i = winio@(
     +'       work if you have the appropriate NAG DLL(s) installed.&')
      i = winio@('%nl   &')
      i = winio@('%nl&')
      i = winio@(
     +'3. Options are in the file x64_change_simfit_version.config&')
      i = winio@('%nl   &')
      i = winio@('%nl%cn%*.*ls[limit_height]&', 
     +nwide, nhigh, comments, nitems, numdec, high) 
      i = winio@('%ff%cn%8bt[OK]  %8^bt[Help]', i_give_help)
c
c decide if action is needed
c       
      if (there .and. numdec.eq.nitems) then
         action = .false.
      else
         action = .true.
      endif         
c
c if so attempt to overwrite 
c         
      if (action) then
         over = .false.
         try_cissue = use_cissue
         source = dlls(numdec)
         targit = word13
         done = CopyFile(source, targit, over)
         if (done) then
c
c success using CopyFile
c                 
            isend = 1
            call w_putall (isend, 
     +                     yes1)
         elseif (try_cissue) then
c
c failure using CopyFile so try cissue@
c                 
            i = len_trim(source)
            strng = blank
            strng = 'copy'//blank//source(1:i)//blank//targit
            call cissue@(strng, ifail)
            if (ifail.eq.0) then
c
c success using cissue@
c              
               isend = 1
               call w_putall (isend,
     +                        yes2)
            else  
c
c failure using cissue@
c                     
               isend = 4
               call w_putall (isend,    
     +                        no)  
               call more_info
            endif
         else 
c
c failure but cissue@ not tried
c            
            isend = 4
            call w_putall (isend,    
     +                     no)  
            call more_info          
         endif             
      endif 
      end  
  
c------------------------------------------------------------------                
c
      recursive integer function i_give_help()
      implicit none
      integer  k
      integer  winio@
      i_give_help = 1

      k = winio@('%ca[Program: change_simfit_version.exe]&')

      k = winio@(
     +'The program simfit_setup.exe installs the Academic version of&')

      k = winio@('%nl&')
      k = winio@(
     +'Simfit and you would usually accept this as the default, since&')  
       
      k = winio@('%nl&')
      k = winio@(
     +'it requires no external numerical analysis libraries.&')  

      k = winio@('%nl &')
      
      k = winio@('%nl&')
      k = winio@(
     +'However, if you have the NAG library DLLs, e.g. Mark24, you&')  
     
      k = winio@('%nl&')
      k = winio@(
     +'can link to these for extra functionality, as now explained.&')  

      k = winio@('%nl &')

      k = winio@('%tc[red]&')  
      k = winio@('%nl&')   
      k = winio@(
     +'The Academic version of Simfit uses the DLL:&')
     
      k = winio@('%tc[black]&')
      k = winio@('%nl&')
      k = winio@(
     +'x64_maths.dll %talinked to x64_numbers.dll&')
      
      k = winio@('%nl &')
 
      k = winio@('%tc[red]&')    
      k = winio@('%nl&')
      k = winio@(
     +'The NAG library Mark22 version of Simfit uses the DLL:&')  
 
      k = winio@('%tc[black]&')
      k = winio@('%nl&')
      k = winio@(
     +'x64_maths.dll  %talinked to the NAG library Mark24 DLLs&')
      
      k = winio@('%nl &')

      k = winio@('%tc[red]&')    
      k = winio@('%nl&')
      k = winio@(
     +'Configuring for the NAG library Mark24 version replaces&')
 
      k = winio@('%tc[black]&')
      k = winio@('%nl&')
      k = winio@(
     +'x64_maths.dll %taby x64_maths.dll linked to Mark24 Dlls.&')

      k = winio@('%nl &')

      k = winio@('%tc[red]&')
      k = winio@('%nl&')
      k = winio@(
     +'Configuring for the Academic version replaces&')

      k = winio@('%tc[black]&')
      k = winio@('%nl&')
      k = winio@(
     +'x64_maths.dll  %taby x64_maths.dll linked to x64_numbers.dll.&')

      k = winio@('%nl &')
      
      k = winio@('%tc[blue]&')
      k = winio@('%nl&')
      k = winio@(
     +'If Simfit is not running, you can configure retrospectively&')

      k = winio@('%nl&')
      k = winio@(
     +'using this program from the ...\Simfit\bin folder.&')

      k = winio@('%nl  &')

      k = winio@('%tc[black]&')
      k = winio@('%nl&')

      k = winio@('%nl&')
      k = winio@(
     +'If x64_change_simfit_version.exe will not overwrite existing&')
     
      k = winio@('%nl&')

      k = winio@(
     +'DLL, just right click and choose to ... Run As Administrator.&')

      k = winio@('%ff%nl&')
      k = winio@('%cn%^8bt[OK]', 'exit')    
 
      end 
c
c----------------------------------------------------------------------------
c
      subroutine w_putall (isend,
     +                     strng)
c
c action: put one line messages out in a graphics environment
c author: w.g.bardsley, university of manchester, u.k., 15/11/2004
c         20/03/2007 edited for w_clearwin.dll
c   
c         isend: (input/unchanged) action as follows:
c                isend = 1: advice
c                isend = 2: caution
c                isend = 3: warning
c                isend = 4: fatal
c         strng: (input/unchanged) string
c
      implicit none
      include <windows.ins>
c
c argument
c
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: strng
c
c locals
c
      integer    i, j, k
      character  caption*100, line*100
      character  blank*1
      parameter (blank = ' ')
      logical    advice, caution, warning, fatal
c
c check
c
      if (isend.lt.1 .or. isend.gt.4 .or. strng.eq.blank) return
c
c initialise
c
      advice = .false.
      caution = .false.
      warning = .false.
      fatal = .false.
      if (isend.eq.1) then
         advice = .true.
         line = 'ADVICE:'//blank//strng
      elseif (isend.eq.2) then
         caution = .true.
         line = 'CAUTION:'//blank//strng
      elseif (isend.eq.3) then
         warning = .true.
         line = 'WARNING:'//blank//strng
      elseif (isend.eq.4) then
         fatal = .true.
         line = 'FATAL:'//blank//strng
      endif

c
c use Windows MessageBox function as in i = MessageBox (j, line, caption, k)
c j = 0 implies null handle, icon type as follows:-
C k = MB_ICONHAND = 16 (fatal, x icon),
c k = MB_ICONEXCLAMATION = 48 (warning, ! icon)
c k = MB_ICONINFORMATION = 64 (information, i icon)
c k = k + SYSTEMMODAL + MB_OK makes the window a top-level window with 1 button
c


      j = 0
      if (advice) then
         caption = 'Simfit: advisory message'
         k = MB_ICONINFORMATION
      elseif (caution) then
         caption = 'Simfit: cautionary message'
         k = MB_ICONEXCLAMATION
      elseif (warning) then
        caption = 'Simfit: warning message'
         k = MB_ICONEXCLAMATION
      elseif (fatal) then
         caption = 'Simfit: fatal error message'
         k = MB_ICONHAND
      endif
      k = k + MB_SYSTEMMODAL + MB_OK
      i = messagebox (j, line, caption, k)
      k = i!to silencs ftn95
      end
c
c

c----------------------------------------------------------------------------
cc
             
      subroutine more_info
      implicit   none
      integer    i, k, winio@
      integer    n
      parameter (n = 27)
      character (len = 80) :: text(30)
      write (text,100)
      k = winio@('%ca[Failure using change_simfit_version.exe]&')
      do i = 1, n
         if (i.eq.8 .or. i.eq.21) then
            k = winio@('%tc[red]&')
         else
            k = winio@('%tc[black]&')
         endif     
         k = winio@(text(i)//'%nl&')
      enddo   
      k = winio@('%ff%nl &')  
      k = winio@('%cn%^8bt[OK]', 'exit')         
  100 format (
     + 'This program (x64_change_simfit_version.exe) cannot overwrite'
     +/'the target, i.e., the dynamic link library'
     +/'x64_maths.dll,'
     +/'by one or more of the source files, e.g.,'
     +/'Academic_maths.dll, or'
     +/'one of the NAG library DLL linked versions of x64_maths.dll.'
     +/
     +/'You must be running as ADMINISTRATOR. Other possibilities are.'
     +/
     +/'You are not running from within the ...\Simfit\bin folder.'
     +/
     +/'Simfit is now running and so it is linked to the target.'
     +/
     +/'The source may be missing.'
     +/ 
     +/'The target may have read-only permission.'
     +/
     +/'The operating system will not allow the targets to be'
     +/'overwritten by the sources, e.g., as in Windows Vista.'
     +/
     +/'The solutions'
     +/
     +/'1. Make sure you have a copy of the correct source.'
     +/'2. Make sure Simfit is not running.'
     +/'3. Right click on x64_change_simfit_version.exe and choose'
     +/'        ...Run as adminstrator.'
     +/'4. Otherwise overwrite x64_maths.dll manually in ..\Simfit\bin')
      end
c
c-----------------------------------------------------------------
c
                    