C      program main
C      implicit none
C      integer isend, k
C      character (len = 30) version 
C      external run6_logo
C      isend = 1
C      version = 'Version 8.1.0'
C      k = winio@('%bg[grey]&')
C      call run6_logo (isend, version)
C      k = winio@(' ')
C      end



C
C RUN6_3.INS: RUN6_LOGO
c i_run_simfit_programs
c run_simfit_programs
C =====================
C
C
      SUBROUTINE RUN6_LOGO (ISEND, VERSION)
C
C ACTION: SIMFIT main front page logo
C AUTHOR: w.g.bardsley, university of manchester, u.k. 08/11/2003
C         07/08/2007 extensively revised for version 6
C         08/10/2022 added new websites and raised the logo from 3*depth to 2*depth
C         07/12/2023 extensive editing to change position, size and suppress items
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
C
C Arguments
C
      INTEGER,             INTENT (IN) :: ISEND
      CHARACTER (LEN = *), INTENT (IN) :: VERSION
C
C Locals
C
C      INTEGER   (KIND = 7) HANDLE 
      INTEGER    BOOL, HANDLE, K0, K1
      PARAMETER (BOOL = 1, HANDLE = 0, K0 = 0, K1 = 1)
      INTEGER    K, KX, KY
      INTEGER    NUMRGB$
      DOUBLE PRECISION DEFOLT, FACTOR, SCALEX, SCALEY
      PARAMETER (DEFOLT = 1024.0D+00, SCALEX = 0.75+00,
     +           SCALEY = 0.50D+00)
C ... Colours
      INTEGER    ICOLOR, CNAME, CTITLE, CSHADE
C ... Simfit: number of shading loops
      INTEGER    NSHADE
      PARAMETER (NSHADE = 5)
C ... Title: font size
      INTEGER    IFY1
      PARAMETER (IFY1 = 30)
C ... Character: font size for subheading
      INTEGER    IFY2
      PARAMETER (IFY2 = 9)
C ... Name: font size
C      INTEGER    IFY3
C      PARAMETER (IFY3 = 9)
C ... Temporary integers
      INTEGER    I, IDX, IDY
      integer    iy_start, width, depth
      double precision half, yscale
      parameter (half = 0.5d+00, yscale = 1.25)
C ... Texts
      CHARACTER  SIMFIT*6
      PARAMETER (SIMFIT = 'Simfit')
C      CHARACTER  TITLE*46
C      PARAMETER (TITLE = 
C     +          'Simulation, fitting, statistics, and plotting.')
C      CHARACTER  NAME*44
C      PARAMETER (NAME = 'W.G.Bardsley, University of Manchester, U.K.')   
C      CHARACTER  WEBSITE0*17
C      PARAMETER (WEBSITE0 = 'https://simfit.uk') 
C      CHARACTER  WEBSITE*21
C      PARAMETER (WEBSITE = 'https://simfit.org.uk')
C      CHARACTER  WEBSITE1*30
C      PARAMETER (WEBSITE1 = 'https://simfit.silverfrost.com')
C ... Externals
      EXTERNAL   W_SYSPAR
      EXTERNAL   NUMRGB$
      INTRINSIC  DBLE, NINT
      IF (ISEND.EQ.1) THEN
C
C Define the colours
C
         K = USE_RGB_COLOURS@(HANDLE, BOOL)
         ICOLOR = 38
         CTITLE = NUMRGB$(ICOLOR)
         ICOLOR = 0
         CSHADE = NUMRGB$(ICOLOR)
         ICOLOR = 15
         CNAME = NUMRGB$(ICOLOR)
         ICOLOR = 15 
C         CTEXT = NUMRGB$(ICOLOR)
C         ICOLOR = 15
C         CWEB = NUMRGB$(ICOLOR)
C
C Set up the screen and text attributes
C
         CALL W_SYSPAR (K, 'x')
         KX = NINT(DBLE(K)*SCALEX)
         FACTOR = DBLE(K)/DEFOLT
         CALL W_SYSPAR (K, 'y')
         KY = NINT(DBLE(K)*SCALEY)
         IDX = K0
         IDY = K0
         K = WINIO@('%`cu&', CURSOR_ARROW)

         k = winio@('%pv%gr[rgb_colours]&', kx, ky)
         
         K = USE_RGB_COLOURS@(HANDLE, BOOL)
         
C Draw shading then Simfit
C
         CALL SELECT_FONT@('Times New Roman')
         K = K1
         CALL ITALIC_FONT@(K)
         IDY = NINT(FACTOR*DBLE(IFY1))
         
         idx = nint(half*dble(idy))
                  
         CALL SIZE_IN_PIXELS@(IDY, IDX)
         
         call get_text_size@(simfit, width, depth)
         idx = nint(half*dble(kx - width))
         iy_start = 1*depth
         idy = iy_start
         
         DO I = K1, NSHADE
            IDX = IDX - K1
            IDY = IDY - K1
            CALL DRAW_CHARACTERS@(SIMFIT, IDX, IDY, CSHADE)
         ENDDO
         IDX = IDX - K1
         IDY = IDY - K1
         CALL DRAW_CHARACTERS@(SIMFIT, IDX, IDY, CTITLE)
C
C Version
C
         CALL SELECT_FONT@('Microsoft Sans Serif Regular')
         K = K0
         
         IDY = NINT(1.25d+00*FACTOR*DBLE(IFY2))
         idx = nint(half*dble(idy))
         
         CALL SIZE_IN_PIXELS@(IDY, IDX)
         
         call get_text_size@(version(1:leng(version)), width, depth)
         idx = nint(half*dble(kx - width))
         iy_start = iy_start + nint(yscale*dble(depth))
         idy = iy_start
         
         CALL DRAW_CHARACTERS@(VERSION, IDX, IDY, CNAME)         
C
C Draw text
C
C         CALL SELECT_FONT@('Arial')
C         K = K0
C         CALL BOLD_FONT@(K)
C         K = K0
C         CALL ITALIC_FONT@(K)C

C         IDY = NINT(FACTOR*DBLE(IFY2))
C         idx = nint(half*dble(idy))
C         CALL SIZE_IN_PIXELS@(IDY, IDX)
C         
C         call get_text_size@(title, width, depth)
C         idx = nint(half*dble(kx - width))
C         iy_start = iy_start + nint(yscale*dble(depth))
C         idy = iy_start
C         
C         CALL DRAW_CHARACTERS@(TITLE, IDX, IDY, CTEXT)
C
C
C Draw name
C
C         CALL SELECT_FONT@('Times New Toman')
C         K = K1
C        CALL ITALIC_FONT@(K)
C
C         IDY = NINT(FACTOR*DBLE(IFY3))
C         
C         idx = nint(half*dble(idy))
C         
C         CALL SIZE_IN_PIXELS@(IDY, IDX)
C         
C         call get_text_size@(name, width, depth)
C         idx = nint(half*dble(kx - width))
C         iy_start = iy_start + nint(yscale*dble(depth))
C         idy = iy_start
C         
C         CALL DRAW_CHARACTERS@(NAME, IDX, IDY, CNAME)


C
C Web sites
C
         
C         call get_text_size@(website0, width, depth)
C         iy_start = iy_start + nint(yscale*dble(depth))
C         idy = iy_start
C         
C         CALL DRAW_CHARACTERS@(WEBSITE0, IDX, IDY, CWEB)

C         call get_text_size@(website, width, depth)
C         iy_start = iy_start + nint(yscale*dble(depth))
C         idy = iy_start
C         
C         CALL DRAW_CHARACTERS@(WEBSITE, IDX, IDY, CWEB)

C         iy_start = iy_start + nint(yscale*dble(depth))
C         idy = iy_start
         
C         CALL DRAW_CHARACTERS@(WEBSITE1, IDX, IDY, CWEB)

      ELSE
C
C Set up the screen and text attributes
C
         CALL W_SYSPAR (K, 'x')
         KX = NINT(DBLE(K)*SCALEX)
         FACTOR = DBLE(K)/DEFOLT
         CALL W_SYSPAR (K, 'y')
         KY = NINT(DBLE(K)*SCALEY)
         IDX = K0
         IDY = K0
         K = WINIO@('%`cu&', CURSOR_ARROW)
         K = WINIO@('%pv%gr[rgb_colours]&', KX, KY)
      ENDIF
      END
C
C
      recursive integer function i_run_simfit_programs()
      implicit none
      external run_simfit_programs
      i_run_simfit_programs = 1
      call run_simfit_programs
      end
c
c
      subroutine run_simfit_programs
      implicit   none
      integer    numdec, numopt
      parameter (numopt = 39)
      character  fname(numopt)*30, text(numopt)*100
      external   listbx, run_simfit
      write (text,100)
      numdec = 1
      call listbx (numdec, numopt,
     +             text) 
      if (numdec.eq.1) then
         return
      else
         numdec = numdec - 1
      endif      
      fname(1) = 'x64_adderr.exe'
      fname(2) = 'x64_average.exe'
      fname(3) = 'x64_binomial.exe'
      fname(4) = 'x64_calcurve.exe'
      fname(5) = 'x64_chisqd.exe'
      fname(6) = 'x64_compare.exe'
      fname(7) = 'x64_csafit.exe'
      fname(8) = 'x64_deqsol.exe'
      fname(9) = 'x64_editfl.exe'
      fname(10) = 'x64_editmt.exe'
      fname(11) = 'x64_editps.exe'
      fname(12) = 'x64_eoqsol.exe'
      fname(13) = 'x64_exfit.exe'
      fname(14) = 'x64_ftest.exe'
      fname(15) = 'x64_gcfit.exe'
      fname(16) = 'x64_help.exe'
      fname(17) = 'x64_hlfit.exe'
      fname(18) = 'x64_inrate.exe'
      fname(19) = 'x64_linfit.exe'
      fname(20) = 'x64_makcsa.exe'
      fname(21) = 'x64_makdat.exe'
      fname(22) = 'x64_makfil.exe'
      fname(23) = 'x64_maklib.exe'
      fname(24) = 'x64_makmat.exe'
      fname(25) = 'x64_maksim.exe'
      fname(26) = 'x64_mmfit.exe'
      fname(27) = 'x64_normal.exe'
      fname(28) = 'x64_polnom.exe'
      fname(29) = 'x64_qnfit.exe'
      fname(30) = 'x64_rannum.exe'
      fname(31) = 'x64_rffit.exe'
      fname(32) = 'x64_rstest.exe'
      fname(33) = 'x64_sffit.exe'
      fname(34) = 'x64_simplot.exe'
      fname(35) = 'x64_simstat.exe'
      fname(36) = 'x64_spline.exe'
      fname(37) = 'x64_ttest.exe'
      fname(38) = 'x64_usermod.exe'
      call run_simfit (fname(numdec))
  100 format (
     + 'Cancel  `No action'
     +/'adderr  `Add random error to exact data'
     +/'average `Average values, thresholds, and areas'
     +/'binomial`Binomial and Poisson distributions'
     +/'calcurve`Cubic spline calibration curves'
     +/'chisqd  `Chi-square distribution'
     +/'compare `Spline smoothing to compare two curves'
     +/'csafit  `Flow cytometry analysis'
     +/'deqsol  `Simulate and fit differential equations'
     +/'editfl  `Edit curve fitting type data files'
     +/'editmt  `Edit vector and matrix type data files'
     +/'editps  `Edit PostScript files and make collages'
     +/'eoqsol  `Optimal design for data point spacing'
     +/'exfit   `Fit exponential functions'
     +/'ftest   `F distribution'
     +/'gcfit   `Fit growth and survival curves'
     +/'help    `Tutorials'
     +/'hlfit   `Fit High/Low affinity ligand binding sites'
     +/'inrate  `Estimate initial rates and asymptotic slopes'
     +/'linfit  `Fit linear and GLM models'
     +/'makcsa  `Make flow cytometry data'
     +/'makdat  `Make exact data from model equations'
     +/'makfil  `Make a curve fitting file from raw data'
     +/'maklib  `Make a library file from existing files'
     +/'makmat  `Make a vector or matrix file from raw data'
     +/'maksim  `Make a data file from a spreadsheet table'
     +/'mmfit   `Fit Michaelis-Menten functions'
     +/'normal  `Normal distribution'
     +/'polnom  `Fit polynomials and use for calibration'
     +/'qnfit   `Advanced curve fitting'
     +/'rannum  `Generate random numbers, walks, or matrices'
     +/'rffit   `Fit positive rational functions'
     +/'rstest  `Runs, signs, and other nonparametric tests'
     +/'sffit   `Fit cooperative ligand binding saturation functions'
     +/'simplot `Comprehensive graph plotting package'
     +/'simstat `Comprehensive statistical analysis package'
     +/'spline  `Spline fitting'
     +/'ttest   `t distribution'
     +/'usermod `User-defined models')
      end
c
c      
