c
c run6_4:
c =======
c config_wizard
c create_inout_tmp_files
c i_call_resdef
c

c 
c----------------------------------------------------------------------
c
      subroutine config_wizard (isend, nval,
     +                          cval)
c
c Note that this must be called with cval as defined in the w_simfit.cfg file
c 23/12/2012 now attempts to repair cval(3)
c 17/02/2020 no longer tests for ghostscript, gsview, or acrobat (or equivalents)
c 09/12/2022 extensive simplification and now defines cval(3) using x_repair if the driver is correct
c
c If this program is called x64_simfit.exe then there are three possible errors
c 1) error1 checks that the program is ...\simfit\bin\x64_simfit.exe
c 2) error2 checks that cval(3) ends in ...\simfit\bin or ...\simfit\bin\
c 3) error3 checks that cval(3) does point to a valid simfit installation
c If erors occur a correction is attempted
c To avoid such errors in development the program must only be called x64_simfit.exe
c
      implicit   none
c
c arguments
c      
      integer,             intent (in)    :: isend, nval(12)
      character (len = *), intent (inout) :: cval(12)
c
c locals
c      
      integer    i, icolor, imiss, k, l1, l2, numrgb$, numtxt
      integer    jsend, ntext
      parameter (jsend = 4, ntext = 27)
      integer    numbld(ntext)
      integer    n0, n1, n2, n4, n12, n15, n38
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n12 = 12, n15 = 15,
     +           n38 = 38)
      character (len = 1024) driver, folder, pname(38), simfit, 
     +           tname(39)
      character (len = 100 ) text(40)
      character (len = 80  ) trim80
      character (len = 5   ) word5 
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    error1, error2, error3, there, read_only
      external   attrib, table1, wgbini$, lcase1, trim80,
     +           w_chkcfg, numrgb$, putadv, patch2, allcfg,
     +           x_repair
      external   help_version7
      intrinsic  len_trim
      data       numbld / ntext*0 / 
c
c initialise cval(3), define errors and get the driver
c     
      cval(3) = blank
      error1 = .true.
      error2 = .true.  
      error3 = .true.     
      call get_program_name@(driver)
      call lcase1 (driver)
      simfit = driver
c
c see if this subroutine is being called by the driver w_simfit.exe
c  
      l1 = 1
      l2 = len_trim(simfit)
      if (simfit(l2 - 25:l2).eq.'\simfit\bin\x64_simfit.exe') then
          error1 = .false.
      else
         call putadv (
     +'Path-filename should end like ...\simfit\bin\x64_simfit.exe')
         return
      endif  
      cval(3) = simfit(l1:l2 - 15)
      error2 = .false.
      call x_repair (jsend,
     +               cval(3),
     +               error3)
      if (error1 .or. error2 .or. error3) then
         call putadv (
     +'w_simfit.cfg: path 3 is not correct ... re-configure')       
         return
      endif  
      l2 = l2 - 14  
      
      if (isend.eq.n0) then
c
c nval(5) ... check for missing and obsolete programs if required
c =======
c

         if (nval(5).eq.n1) then
c
c Program files after first making sure that l2 > 0
c   
            pname(1) = simfit(l1:l2)//'x64_adderr.exe'
            pname(2) = simfit(l1:l2)//'x64_average.exe'
            pname(3) = simfit(l1:l2)//'x64_binomial.exe'
            pname(4) = simfit(l1:l2)//'x64_calcurve.exe'
            pname(5) = simfit(l1:l2)//'x64_chisqd.exe'
            pname(6) = simfit(l1:l2)//'x64_compare.exe'
            pname(7) = simfit(l1:l2)//'x64_csafit.exe'
            pname(8) = simfit(l1:l2)//'x64_deqsol.exe'
            pname(9) = simfit(l1:l2)//'x64_editfl.exe'
            pname(10) = simfit(l1:l2)//'x64_editmt.exe'
            pname(11) = simfit(l1:l2)//'x64_editps.exe'
            pname(12) = simfit(l1:l2)//'x64_eoqsol.exe'
            pname(13) = simfit(l1:l2)//'x64_exfit.exe'
            pname(14) = simfit(l1:l2)//'x64_ftest.exe'
            pname(15) = simfit(l1:l2)//'x64_gcfit.exe'
            pname(16) = simfit(l1:l2)//'x64_help.exe'
            pname(17) = simfit(l1:l2)//'x64_hlfit.exe'
            pname(18) = simfit(l1:l2)//'x64_inrate.exe'
            pname(19) = simfit(l1:l2)//'x64_linfit.exe'
            pname(20) = simfit(l1:l2)//'x64_makcsa.exe'
            pname(21) = simfit(l1:l2)//'x64_makdat.exe'
            pname(22) = simfit(l1:l2)//'x64_makfil.exe'
            pname(23) = simfit(l1:l2)//'x64_maklib.exe'
            pname(24) = simfit(l1:l2)//'x64_makmat.exe'
            pname(25) = simfit(l1:l2)//'x64_maksim.exe'
            pname(26) = simfit(l1:l2)//'x64_mmfit.exe'
            pname(27) = simfit(l1:l2)//'x64_normal.exe'
            pname(28) = simfit(l1:l2)//'x64_polnom.exe'
            pname(29) = simfit(l1:l2)//'x64_qnfit.exe'
            pname(30) = simfit(l1:l2)//'x64_rannum.exe'
            pname(31) = simfit(l1:l2)//'x64_rffit.exe'
            pname(32) = simfit(l1:l2)//'x64_rstest.exe'
            pname(33) = simfit(l1:l2)//'x64_sffit.exe'
            pname(34) = simfit(l1:l2)//'x64_simplot.exe'
            pname(35) = simfit(l1:l2)//'x64_simstat.exe'
            pname(36) = simfit(l1:l2)//'x64_spline.exe'
            pname(37) = simfit(l1:l2)//'x64_ttest.exe'
            pname(38) = simfit(l1:l2)//'x64_usermod.exe'
            imiss = n1
            do i = n1, n38
               call attrib (pname(i),
     +                      there, read_only)
               if (.not.there) then
                  imiss = imiss + n1
                  tname(imiss) = pname(i)
               endif
            enddo
            if (imiss.gt.n1) then
               if (imiss.eq.n2) then
                  tname(1) =
     +'This program is missing from your Simfit\bin folder:'
               else
                  tname(1) =
     +'These programs are missing from your Simfit\bin folder:'
               endif
               icolor = n15
               call table1 (icolor, 'OPEN')
               icolor = n4
               call table1 (icolor, tname(1))
               icolor = n0
               do i = n2, imiss
                  call table1 (icolor, tname(i))
               enddo
               call table1 (icolor, 'CLOSE')
            endif
            if (l2.ge.5) then
               word5 = simfit(l2 - 4:l2)
               call lcase1 (word5)
            else
               word5 = blank
            endif      
            if (word5.eq.'\bin\') then    
c
c PS and PDF files
c
               pname(1) = simfit(l1:l2 - 4)//'doc\'//'pscodes.ps'
               pname(2) = simfit(l1:l2 - 4)//'dem\'//'simfig1.ps'
               pname(3) = simfit(l1:l2 - 4)//'dem\'//'simfig2.ps'
               pname(4) = simfit(l1:l2 - 4)//'dem\'//'simfig3.ps'
               pname(5) = simfit(l1:l2 - 4)//'dem\'//'simfig4.ps'
               pname(6) = simfit(l1:l2 - 4)//'doc\'//'simfonts.ps'
               pname(7) = simfit(l1:l2 - 4)//'doc\'//'psfragex.ps'
               pname(8) = simfit(l1:l2 - 4)//'doc\'//'w_examples.pdf'
               pname(9) = simfit(l1:l2 - 4)//'doc\'//'pscodes.pdf'
               pname(10) = simfit(l1:l2 - 4)//'doc\'//'ms_office.pdf'
               pname(11) = 
     +         simfit(l1:l2 - 4)//'doc\'//'simfit_summary.pdf'
               pname(12) = simfit(l1:l2 - 4)//'doc\'//'w_manual.pdf'
               imiss = n1
               do i = n1, n12
                  call attrib (pname(i),
     +                         there, read_only)
                  if (.not.there) then
                     imiss = imiss + n1
                     tname(imiss) = pname(i)
                  endif
               enddo
               if (imiss.gt.n1) then
                  if (imiss.eq.n2) then
                     tname(1) =
     +'This file is missing from your Simfit\doc folder:'
                  else
                     tname(1) =
     +'These files are missing from your Simfit\doc folder:'
                  endif
                  icolor = n15
                  call table1 (icolor, 'OPEN')
                  icolor = n4
                  call table1 (icolor, tname(1))
                  icolor = n0
                  do i = n2, imiss
                     call table1 (icolor, tname(i))
                  enddo
                  call table1 (icolor, 'CLOSE')
               endif
            else
               error1 = .true.
               error2 = .true.
            endif
         endif
 
                    

c
c nval(6) ... check configuration
c =======
c

         if (nval(6).eq.n1) then
            k = - n1
            call wgbini$(k)
c
c check that nval(10) to nval(12) are in range
c            
            if (nval(10).lt.50 .or. nval(10).gt.95) call putadv (
     +'Plot size is outside the range 50% to 95% ... Re-configure ?')               
            if (nval(11).lt.70 .or. nval(11).gt.130) call putadv (
     +'Font size is outside the range 70% to 130% ... Re-configure ?') 
           if (nval(12).lt.20 .or. nval(12).gt.60) call putadv (
     +'No. table rows is outside the range 20 to 60 ... Re-configure ?') 
c
c call allcfg to make sure auxiliaries are not read-only
c  
            call allcfg                 
         else
            k = n0
            call wgbini$(k)
         endif        
        
c
c nval(7) ... do the users programs exist ?
c =======
c
         numtxt = n2
         
         if (nval(7).eq.n1) then
            call attrib (cval(1),
     +                   there, read_only)
            if (.not.there) then
               numtxt = numtxt + n1
               text(numtxt) = 'Text editor'
            endif
            call attrib (cval(2),
     +                   there, read_only)
            if (.not.there) then
               numtxt = numtxt + n1
               text(numtxt) =  'Explorer'
            endif
c
c nval(11) ... does a pdf reader exist ?
c =======
c            
c            call attrib (cval(11),
c     +                   there, read_only)
c            if (.not.there) then
c               numtxt = numtxt + n1
c               text(numtxt) = 'PDF-reader'
c            endif

            call attrib (cval(12),
     +                   there, read_only)
            if (.not.there) then
               numtxt = numtxt + n1
               text(numtxt) = 'Calculator'
            endif
         endif

c
c nval(8) ... do Ghostscript and Gsview exist ?
c =======
c
c
c         if (nval(8).eq.n1) then
c            call attrib (cval(8),
c     +                   there, read_only)
c            if (.not.there) then
c               numtxt = numtxt + n1
c               text(numtxt) = 'Ghostscript'
c            endif
c            call attrib (cval(10),
c     +                   there, read_only)
c            if (.not.there) then
c               numtxt = numtxt + n1
c               text(numtxt) = 'PS-viewer'
c            endif
c         endif

         if (numtxt.gt.2) then
            if (numtxt.eq.3) then
               text(1) =
     +'The following program could not be found'
            else
               text(1) =
     +'The following programs could not be found'
            endif
            text(2) = blank
            numtxt = numtxt + n1
            text(numtxt) = blank
            numtxt = numtxt + n1
            text(numtxt) =
     +'Configure Simfit with the [Configure] then [Check] options'
            numtxt = numtxt + n1
            text (numtxt) =
     +'or use Windows Find/Search to get correct paths/filenames.'
            icolor = n15
            call table1 (icolor, 'OPEN')
            do i = n1, numtxt
               if (i.eq.n1) then
                  icolor = n4
               else
                  icolor = n0
               endif
               call table1 (icolor, text(i))
            enddo
            call table1(icolor, 'CLOSE')
         endif
         
      endif
c
c inform user if there is a bad configuration
c
      if (error1 .or. error2) then
         write (text,100) trim80(driver), trim80(folder)
         numbld(1) = 4
         numbld(13) = 1
         numbld(17) = 1
         numbld(19) = 4
         call patch2 (numbld, ntext,
     +                text)
        call help_version7 ('version7')
      endif
c
c always call w_chkcfg to populate file histories
c
      call w_chkcfg
c
c always call numrgb$ to see if is there a current version of w_ps.cfg
c

      i = numrgb$(n0)  

c
c format statement
c       
  100 format (
     + 'Simfit has not been installed and configured correctly.'
     +/             
     +/'The installation folder must be like C:\Program Files\Simfit or'
     +/'C:\Program Files (x86)\Simfit in 64 bit Windows, i.e. a folder'
     +/'ending in \Simfit. The installation program makes a tree below'
     +/'this top-level folder for binaries (bin), documents (doc), and'
     +/'demonstration data (dem), which must be present. Also the'             
     +/'[Program Folder] must be as in C:\Program Files\Simfit\bin,'
     +/'or C:\Program Files (x86)\simfit\bin.'
     +/             
     +/'The Simfit driver you are using is:'             
     +/             
     +/A             
     +/             
     +/'The [Program Folder] at w_simfit.cfg line 15 is:'
     +/             
     +/A             
     +/             
     +/'Use [Config],[Check],[Apply] to solve this problem as follows.'  
     +/         
     +/'1)`Read version7.txt (next page) to understand the problem.' 
     +/'2)`Make sure the top-level folder name ends in ...\Simfit'
     +/'3)`You may have to re-name the current top-level folder'             
     +/'4)`Check that the installation tree is as in version7.txt'
     +/'5)`Use [Config], edit the the [Program Folder], press [Apply].' 
     +/'6)`Check that the driver is like \...\Simfit\bin\x64_simfit.exe'
     +/'7)`Check that the [Program Folder] is like \...\Simfit\bin')
      end
c 
c----------------------------------------------------------------------------
c
      subroutine create_inout_tmp_files
c
c create w_in.tmp to save names of files analysed
c
      implicit   none
      integer    ios, nout
      integer    n6
      parameter (n6 = 6)
      character  data1*100, fname*1024, sim256*1024
      character  w_in_tmp*8, w_out_tmp*9
      parameter (w_in_tmp = 'w_in.tmp', w_out_tmp = 'w_out.tmp')
      logical    there, read_only
      logical    askif
      parameter (askif = .false.)
      external   attrib, sim256, infofl, deleet, getnou
            
      fname = sim256(w_in_tmp)  
      call attrib (fname,
     +             there, read_only)
      if (there) then
         if (read_only) then 
            call infofl (n6,
     +                   fname)            
         else    
            call deleet (fname,
     +                   askif, there)            
         endif
      endif
      if (.not.there) then 
         call getnou (nout)
         close (unit = nout) 
         open (unit = nout, file = fname, iostat = ios) 
         if (ios.eq.0) then
            data1 = 'Files opened during the current Simfit session:'
            write (nout,'(a)',iostat=ios) data1
         endif   
         close (unit = nout)
      endif

c
c create w_out.tmp to save names of files created
c     
           
      fname = sim256(w_out_tmp)  
      call attrib (fname,
     +             there, read_only)
      if (there) then
         if (read_only) then   
            call infofl (n6,
     +                   fname)       
         else  
            call deleet (fname,
     +                   askif, there)             
         endif
      endif
      if (.not.there) then 
         call getnou (nout) 
         close (unit = nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.0) then
            data1 = 'Files saved during the current Simfit session:'
            write (nout,'(a)',iostat=ios) data1
         endif   
         close (unit = nout)
      endif
      end
c
c
      recursive integer function i_call_resdef()
      implicit   none
      integer    n0
      parameter (n0 = 0)
      external   resdef
      i_call_resdef = 1
      call resdef (n0)
      end
c
c           